% Create header

header = create_header(modulation_decision,QAM_decision,OFDM_decision,...
    file_format,file_name,nr_bits_input,nr_packages,nr_columns,nr_parity_bits,...
    nr_added_zeros, added_number_zeros_hamming,nr_package_samples,k);

% Zeropad header for OFDM
zero_padded_header = zero_padding(header, nr_databits_package);

% Scramble header
P_header = P(1:nr_databits_package);

scrambled_header = xor(zero_padded_header, P_header');

% Add training sequence to header
header_with_training = [training_bits, scrambled_header];

% We need a high energy per bit since the header otherwise has a much lower
% amplitude than the data

Eb_header = 1;
modulated_header = tx_modulation(header_with_training,1, 4, Eb_header);
OFDM_header = OFDM_transmitter_new(modulated_header ,N,BlockLength, L);

% Upconvert header to passband

header_passband = upconvert_package_to_passband_OFDM(OFDM_header, pulse, fs, f0,fs, N, BlockLength);
header_passband = header_passband/max(abs(header_passband));

% One package is the header
%nr_packages = nr_packages + 1;